﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using BSDKW;

namespace SampleMapApplication
{
    /// <summary>
    /// Interaction logic for Credentials.xaml
    /// </summary>
    public partial class Credentials : Window
    {
        BDataLoader bDataLoader;

        public Credentials(BDataLoader bDataLoader)
        {
            InitializeComponent();
            this.bDataLoader = bDataLoader;
        }

        /// <summary>
        /// Generates the connection string to authenticate the credentials from urbex.
        /// </summary>
        private string GetConnectionString()
        {
            return "BlomURBEX3DServer:" + Username.Text + ":" + Password.Password;
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            if (string.IsNullOrWhiteSpace(Username.Text) || string.IsNullOrWhiteSpace(Password.Password))
            {
                //If the username or password is not provided, then ask the user to provide one.
                MessageBox.Show("Username or password should have some value.", "Error", MessageBoxButton.OK, MessageBoxImage.Error);
            }
            else
            {
                //Authenticate the credentials.
                BLerror oResult = bDataLoader.AddDataSource(0, GetConnectionString());

                //If the credentials are authenticated then just close the form and continue; else show error.
                if (oResult == BLerror.BL_SUCCESS)
                {
                    DialogResult = true;
                    this.Close();
                }
                else
                {
                    MessageBox.Show("Authentication failed, please try again.", "Error", MessageBoxButton.OK, MessageBoxImage.Error);
                }
            }
        }
    }
}
